/**
 * Appcelerator Titanium License
 * This source code and all modifications done by Appcelerator
 * are licensed under the Apache Public License (version 2) and
 * are Copyright (c) 2009 by Appcelerator, Inc.
 */

/*
 * Copyright (C) 2008 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#ifndef OpaqueTiString_h
#define OpaqueTiString_h

#include <runtime/UString.h>

namespace TI {
    class Identifier;
    class TiGlobalData;
}

struct OpaqueTiString : public ThreadSafeShared<OpaqueTiString> {

    static PassRefPtr<OpaqueTiString> create() // null
    {
        return adoptRef(new OpaqueTiString);
    }

    static PassRefPtr<OpaqueTiString> create(const UChar* characters, unsigned length)
    {
        return adoptRef(new OpaqueTiString(characters, length));
    }

    static PassRefPtr<OpaqueTiString> create(const TI::UString&);

    UChar* characters() { return this ? m_characters : 0; }
    unsigned length() { return this ? m_length : 0; }

    TI::UString ustring() const;
    TI::Identifier identifier(TI::TiGlobalData*) const;

private:
    friend class WTI::ThreadSafeShared<OpaqueTiString>;

    OpaqueTiString()
        : m_characters(0)
        , m_length(0)
    {
    }

    OpaqueTiString(const UChar* characters, unsigned length)
        : m_length(length)
    {
        m_characters = new UChar[length];
        memcpy(m_characters, characters, length * sizeof(UChar));
    }

    ~OpaqueTiString()
    {
        delete[] m_characters;
    }

    UChar* m_characters;
    unsigned m_length;
};

#endif
